<?LassoScript

	/*
			This page lists all or some of the messages in a given forum. The
		forum is identified by the 'list' action_param. If this param was not 
		given, then don't output anything and the main forum list page will be 
		shown.
		
		Messages are stored in their own table:
		
		messages
			id
			id_forum - the id of the forum the message is in
			id_reply - the id of the message that this is in reply to, if any
			id_author - the id of the message's author
			date - the date the message was posted
			title - the title of the message
			body - the body text for the message
		
			If the id_reply column is null, then the message is a top-level
		message. If the id_reply column is not null, then that message is a
		reply to the top-level message identified by that id. Only top-level
		messages are shown in this list.

			Messages are sorted by date when displayed, with the newest added to
		the bottom of the list. The message title, the date the 
		message was posted, the author's name and the number of replies to the 
		message are shown in the list.
		
	*/
	if (action_param('list')->size);
		local('forumId' = action_param('list'));
		local('skip' = integer(action_param('skip')));

		local('newMessage'=action_param('newMessage'),
				'newTitle'=action_param('title'),
				'newBody'=action_param('body'));

		local('author'=action_param('authorFilter'),
				'body'=action_param('bodyFilter'));
		#author->trim;
		#body->trim;

		// see if a new message is being posted
		if (#newMessage);
			if (!$isLoggedIn); // must be authenticated
				auth;
			/if;
			if (#newTitle->size == 0);
				#newTitle = '(no title)';
			/if;
			inline(-database='op_message_board', -table='messages', 
					'title'=#newTitle, 'body'=#newBody, 
					'id_author'=MessageBoard_findAuthorByName(admin_currentusername), 
					'id_reply'=null, 'id_forum'=#forumId, -add);
			/inline;
		/if;
		
		// see if the admin is deleting one of the messages
		if ($isAdmin && action_param('delmid'));
			local('delMID' = action_param('delmid'));
			inline(-database='op_message_board', -table='messages', -delete, 
					-keyField='id', -keyValue=#delMID);
				inline(-delete, -keyField='id_reply', -keyValue=#delMID);/inline;
			/inline;
		/if;
		
		// validate the forum by searching for it
		inline(-database='op_message_board', -table='forums', -search, -op='eq', 'id'=#forumId, -returnField='title', -returnField='description');
			if (found_count != 0);
				$handled = true;
ljax_target(-notarget); // no ajax only
				'<div class="left_bar">\
				<b class="rboth1 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth4 rleftclr"></b>';
/ljax_target;
ljax_target(-target=array('message_list', 'auth_group'), -notarget);
				/*
					The user may initially not be logged in, but may be authenticated via a LJAX call.
					This means the username is changing dynamically, so we need to update the UI.
				*/
				'<span id="login_info" xmlns="http://www.w3.org/1999/xhtml" class="group_title">\
				Hello, <i>'admin_currentusername'</i>';
				if (!$isLoggedIn);
					' <a href="' Application_appInfo->indexFile '?auth=1">(login)</a>';
				/if;
				'</span>';
/ljax_target;
ljax_target(-notarget); // no ajax only
				'<b class="rboth4 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth1 rleftclr"></b>';
				'</div>';
				'<div class="group_list">\
					<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">';
							// link back to forums list
							'<a href="' Application_appInfo->indexFile '">Forums</a> &gt; ';
							// display this forum's name
							inline(-table='forums', -search, -op='eq', 'id'=#forumId, -returnField='title');
								field('title');
							/inline;
						'</div>\
						<div class="item">'
							encode_html(field('description'));
						'</div>\
					</div>\
					<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">\
							<a href="#" onclick="toggleDisplayBlock(\'new_reply_form_parent\')">Create New Message</a>\
						</div>\
						<div class="item" id="new_reply_form_parent">\
							<form id="new_reply_form" method="POST" action="'response_filepath'" \
									onsubmit="var t = this; Lasso.includeTarget(\'message_list\', {args:this, afterFunc:function(){t.reset(); toggleDisplayBlock(\'new_reply_form_parent\');}}); return false;">\
								Title<br /><input type="text" name="title" size="50" /><br />\
								Body<br /><textarea name="body" style="width: 80%; height: 100px"></textarea><br />\
								<input type="hidden" name="list" value="'#forumId'" />\
								<input type="hidden" name="skip" value="0" />\
								<input type="submit" value="Submit Reply" name="newMessage" />\
							</form>\
						</div>\
					</div>';
/ljax_target; // end of no-LJLAX section

				// check the filters
				if (#author);
					inline(-table='authors', -search, -op='ct', 'name'=#author, -returnField='id', -maxrecords='all');
						local('authorFilter' = array(-opbegin='or'));
						if (found_count > 0);
							records;
								#authorFilter->insert(-op='eq') & insert('id_author'=field('id'));
							/records;
							#authorFilter->insert(-opend);
						else;
							// value provided but no authors matched
							#authorFilter->insert(-op='eq') & insert('id_author'= -1);
						/if;
					/inline;
				/if;
				if (#body);
					local('bodyFilter' = array(-opbegin='or', -op='ct', 'body'=#body, -op='ct', 'title'=#body, -opend));
				/if;

				// search for the top-level messages to show
				inline(-table='messages', -search,
						-op='eq', 'id_forum'=#forumId, local('authorFilter'), local('bodyFilter'), 
						-op='eq', 'id_reply'=null, -skiprecords=#skip, -maxrecords=$max,
						-returnField='id', -returnField='title', -returnField='id_author', 
						-returnField='date', -sortField='date', -sortOrder='descending');
ljax_target(-notarget);
					'<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">';
/ljax_target;
ljax_target('message_list', -notarget);
							'<span class="ghostly" id="shown_info" xmlns="http://www.w3.org/1999/xhtml">';
							if (found_count == 0); // no replies
								'There are no messages in this forum.';
							else (found_count == 1);
								'Showing the single message in this forum.';
							else (found_count == shown_count);
								'Showing all of the ' found_count ' messages in this forum.';
							else ($max == 1 || shown_count == 1);
								'Showing ' (#skip+1) ' of the ' found_count ' messages in this forum.';
							else;
								'Showing ' (#skip+1) ' through ' (#skip + shown_count) ' of the ' found_count ' messages in this forum.';
							/if;
							'</span>';
/ljax_target;
ljax_target(-notarget);
							'<form method="POST" action="'Application_appInfo->indexFile'">';
/ljax_target;
ljax_target('message_list', -notarget);
							'<span class="page_nav" id="nav_control" xmlns="http://www.w3.org/1999/xhtml">&#160;&#160;';
							if (#skip != 0 && $max != 'all');
								'<a onclick="Lasso.includeTarget(\'message_list\', {args:this}); return false;" href="' Application_appInfo->indexFile '?list=' #forumId '&#38;skip=0"> &#171; </a> ';
								'<a onclick="Lasso.includeTarget(\'message_list\', {args:this}); return false;" href="' Application_appInfo->indexFile '?list=' #forumId '&#38;skip=' ((#skip-$max) > -1 ? (#skip-$max) | 0) '"> &#8249; </a> ';
							else;
								' &#171; &#8249; ';
							/if;
							// allow the user to select the number of replies per page to show
							'<input type="hidden" name="skip" value="'#skip'" />\
							<input type="hidden" name="list" value="'#forumId'" />\
							<select name="max" onchange="Lasso.includeTarget(\'message_list\', {args:this.form});">\
								<option value="1"' ($max == 1? ' selected="true"') '>1</option>\
								<option value="3"' ($max == 3? ' selected="true"') '>3</option>\
								<option value="5"' ($max == 5? ' selected="true"') '>5</option>\
								<option value="10"' ($max == 10? ' selected="true"') '>10</option>\
								<option value="all"' ($max == 'all'? ' selected="true"') '>all</option>\
							</select>';
ljax_target(-notarget);		// Safari has a bug whereby dynamically inserted nodes will not respect the <noscript> tags
							// So all noscript stuff ends up being visible after LJAX inserts it into the page
							// Adding an LJAX -notarget here insures that this section is not sent
							// if the current request is an LJAX request
							'<noscript>\
							<input type="submit" name="Select" value="Select" />\
							</noscript>';
/ljax_target;
							if ( $max != 'all' && (#skip+$max) < found_count);
								'<a onclick="Lasso.includeTarget(\'message_list\', {args:this}); return false;" href="' Application_appInfo->indexFile '?list=' #forumId '&#38;skip=' (#skip+$max) '"> &#8250; </a> ';
								'<a onclick="Lasso.includeTarget(\'message_list\', {args:this}); return false;" href="' Application_appInfo->indexFile '?list=' #forumId '&#38;skip=' (found_count-$max) '"> &#187; </a>';
							else;
								' &#8250; &#187;';
							/if;									
							'&#160;&#160;\
							</span>';
/ljax_target;
ljax_target(-notarget);
							'<span class="ghostly">author</span>&#160;\
							<input class="filter" id="author_filter" type="text" name="authorFilter" value="'#author'" 
								onkeyup="var t = this; filterUpdate(function() {
										Lasso.includeTarget(\'message_list\', {args:t.form, argsoverride:{skip:0}});})" />&#160;\
							<span class="ghostly">body/title</span>&#160;\
							<input class="filter" id="body_filter" type="text" name="bodyFilter" value="'#body'" 
								onkeyup="var t = this; filterUpdate(function() {
										Lasso.includeTarget(\'message_list\', {args:t.form, argsoverride:{skip:0}});})" />';
							// Safari has a bug whereby dynamically inserted nodes will not respect the <noscript> tags
							// So all noscript stuff ends up being visible after LJAX inserts it into the page
							// Adding an LJAX -notarget here insures that this section is not sent
							// if the current request is an LJAX request
							'<noscript>\
							<input type="submit" name="Filter" value="Filter" />\
							</noscript>';
							'</form>';
						'</div>';
/ljax_target;
ljax_target('message_list', -notarget); // when -target=message_list, or no target at all
					'<div id="message_list" xmlns="http://www.w3.org/1999/xhtml">';
					records;
						'<div class="item">\
							<div class="item_title">\
								<a href="' Application_appInfo->indexFile '?detail=' field('id') '">'
								encode_html(field('title')) '</a>';
								$isAdmin? (' - <a onclick="Lasso.includeTarget(\'message_list\', {args:this}); return false;" class="delete" href="' Application_appInfo->indexFile '?delmid='field('id')'&#38;list='#forumId'">(delete message and replies)</a>');	
							'</div>\
							<div class="item_description">'
								MessageBoard_findAuthorById(field('id_author')) ' - ' encode_html(field('date'))
							'</div>\
							<div class="item_details">';
								// show the number of replies to this message
								inline(-table='messages', -search, -op='eq', 'id_reply'=field('id'),
										-returnField='id');
									found_count + (found_count == 1? ' Reply' | ' Replies');
								/inline;								
							'</div>\
						</div>\n';
					/records;
					'</div>';
/ljax_target;
				/inline;
ljax_target(-notarget); // no ajax only		
				'</div>\
				</div>';
/ljax_target; // end of no-LJLAX section
			/if;
		/inline;
	/if;
	
	
	
	
?>